/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth.util;

import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeResourceMONode;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeViewNode;
import com.ibm.hwmca.ui.bonsai.earth.util.ViewNodeRetrieverInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class AbstractMOMViewNodeRetriever
implements ViewNodeRetrieverInterface {
    private static final String MOSTATUS_TASKRETRIEVER_KEY = "taskretriever.mo.status";
    private String[][] treePaths;

    public void init(Map params) {
        if (!params.containsKey("paths")) {
            this.treePaths = new String[0][];
            return;
        }
        StringTokenizer paths = new StringTokenizer((String)params.get("paths"), "|");
        StringTokenizer path = null;
        this.treePaths = new String[paths.countTokens()][];
        for (int i = 0; i < this.treePaths.length; ++i) {
            path = new StringTokenizer(paths.nextToken(), ";");
            this.treePaths[i] = new String[path.countTokens()];
            for (int j = 0; j < this.treePaths[i].length; ++j) {
                this.treePaths[i][j] = path.nextToken();
            }
        }
    }

    public List getNodes(BonsaiTreeViewNode parent) {
        BonsaiTreeManager treeManager = BonsaiTreeManager.getBonsaiTreeManager();
        ArrayList earthNodes = new ArrayList();
        for (int i = 0; i < this.treePaths.length; ++i) {
            earthNodes.addAll(treeManager.getTreeNodesByTreePath(this.treePaths[i]));
        }
        ArrayList<BonsaiTreeNode> viewNodes = new ArrayList<BonsaiTreeNode>(earthNodes.size());
        Iterator i = earthNodes.iterator();
        while (i.hasNext()) {
            viewNodes.add(((BonsaiTreeNode)i.next()).createViewNode(parent));
        }
        this.runFilter(viewNodes);
        return viewNodes;
    }

    private void runFilter(List nodes) {
        BonsaiTreeResourceMONode node = null;
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            try {
                node = (BonsaiTreeResourceMONode)iterator.next();
                this.runFilter(node.getChildren());
                if (this.exclude(node)) {
                    iterator.remove();
                    continue;
                }
                node.setTaskRetrieverKey(MOSTATUS_TASKRETRIEVER_KEY);
            }
            catch (ClassCastException ccEx) {
                iterator.remove();
            }
        }
    }

    protected abstract boolean exclude(BonsaiTreeResourceMONode var1);
}

